module.exports = {
    "root": true,
    overrides: [
      /**
       * -----------------------------------------------------
       * TS文件
       * -----------------------------------------------------
       */
      {
        files: ["*.ts"],
        parserOptions: {
          project: [
            "tsconfig.app.json",
            "tsconfig.spec.json",
            "e2e/tsconfig.json",
          ],
          createDefaultProgram: true,
          tsconfigRootDir: __dirname,
        },
        extends: [
          "airbnb-base",
          "plugin:@angular-eslint/ng-cli-compat",
          "plugin:@angular-eslint/ng-cli-compat--formatting-add-on",
          "plugin:@angular-eslint/template/process-inline-templates",
        ],
        rules: {
          // 自定义风格
          "@typescript-eslint/type-annotation-spacing": [2, { // 声明类型时必须无空格
            "overrides": {
              "colon": {
                "before": false,
                "after": false,
              },
              "arrow": {
                "before": true,
                "after": true,
              }
            }
          }],
          "@typescript-eslint/no-unused-expressions": [2, {
            allowShortCircuit: true,
            allowTernary: true,
          }],
          "@typescript-eslint/no-unused-vars": [1, { "args": "none" }],
          "@typescript-eslint/ban-types": [2, {
            "types": {
              "Function": false,
            }
          }],
  
          // 忽略不适用该项目的规则
          "max-len": 0,
          "no-console": 0,
          "dot-notation": 0,
          "camelcase": 0,
          "class-methods-use-this": 0,
          "no-underscore-dangle": 0,
          "no-unused-expressions": 0,
          "eqeqeq": 0,
          "no-tabs": 0,
          "no-underscore-dangle": 0,
          "no-mixed-spaces-and-tabs": 0,
          "no-restricted-syntax": 0,
          "guard-for-in": 0,
          "no-param-reassign": 0,
          "no-unused-vars": 0,
          "no-empty-function": 0,
          "no-useless-constructor": 0,
          "no-shadow": 0,
          "quote-props": 0,
  
          "@typescript-eslint/dot-notation": 0,
          "@typescript-eslint/member-ordering" : 0,
          "import/no-unresolved": 0,
          "import/extensions": 0,
          "import/prefer-default-export": 0,
                  },
      },
      /**
       * -----------------------------------------------------
       * HTML模版文件
       * -----------------------------------------------------
       */
      {
        files: ["*.html"],
        extends: ["plugin:@angular-eslint/template/recommended"],
        rules: {
          "max-len": [0, { code: 140 }],
        },
      },
      /**
       * -----------------------------------------------------
       * 测试文件
       * -----------------------------------------------------
       */
      {
        files: ["*.spec.ts"],
        rules: {
          "no-undef": 0,
        },
      },
    ],
  };
  