import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { HomeComponent } from './page/home/home.component';
import { LoginComponent } from './page/login/login.component';
import { AdminSystemComponent } from './page/admin/admin-system/admin-system.component';
import { UserManageComponent } from './page/admin/user-manage/user-manage.component';

const routes:Routes = [
  { path: 'login', component: LoginComponent },
  {
    path: 'home',
    component: HomeComponent,
    children: [
      {
        path: 'admin',
        component: AdminSystemComponent,
        children: [
          {
            path: '',
            redirectTo: '/home/admin/users',
            pathMatch: 'full',
          },
          {
            path: 'users',
            component: UserManageComponent,
          },
        ],
      },
    ]
  }

];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
