import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { HttpClientModule, HTTP_INTERCEPTORS, HttpClient } from '@angular/common/http';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { NzDividerModule } from 'ng-zorro-antd/divider';
import { NzFormModule } from 'ng-zorro-antd/form';
import { NzIconModule } from 'ng-zorro-antd/icon';
import { NzInputModule } from 'ng-zorro-antd/input';
import { NzCheckboxModule } from 'ng-zorro-antd/checkbox';
import { NzButtonModule } from 'ng-zorro-antd/button';
import { NzSelectModule } from 'ng-zorro-antd/select';
import { NzMessageModule } from 'ng-zorro-antd/message';
import { NzLayoutModule } from 'ng-zorro-antd/layout';
import { NzDropDownModule } from 'ng-zorro-antd/dropdown';
import { NzToolTipModule } from 'ng-zorro-antd/tooltip';
import { NzBadgeModule } from 'ng-zorro-antd/badge';
import { NzTableModule } from 'ng-zorro-antd/table';
import { NzAvatarModule } from 'ng-zorro-antd/avatar';
import { NzTagModule } from 'ng-zorro-antd/tag';
import { NzTabsModule } from 'ng-zorro-antd/tabs';
import { ReactiveFormsModule } from '@angular/forms';
import { ErrorInterceptor } from 'src/app/_helpers/error-interceptor';
import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { LoginComponent } from './page/login/login.component';
import { HomeComponent } from './page/home/home.component';
import { ToolbarComponent } from './page/common/toolbar/toolbar.component';
import { NavigationComponent } from './page/common/navigation/navigation.component';
import { AdminSystemComponent } from './page/admin/admin-system/admin-system.component';
import { UserManageComponent } from './page/admin/user-manage/user-manage.component';
import { SelectComponent } from './page/common/select/select.component';
import { InputComponent } from './page/common/input/input.component';


@NgModule({
  declarations: [
    AppComponent,
    LoginComponent,
    HomeComponent,
    ToolbarComponent,
    NavigationComponent,
    AdminSystemComponent,
    UserManageComponent,
    SelectComponent,
    InputComponent],
  imports: [
    BrowserModule,
    HttpClientModule,
    NzFormModule,
    NzIconModule,
    NzInputModule,
    NzCheckboxModule,
    NzButtonModule,
    NzSelectModule,
    NzMessageModule,
    NzLayoutModule,
    NzDropDownModule,
    NzToolTipModule,
    NzBadgeModule,
    NzTableModule,
    AppRoutingModule,
    BrowserAnimationsModule,
    ReactiveFormsModule,
    NzAvatarModule,
    NzDividerModule,
    NzTagModule,
    NzTabsModule
  ],
  providers: [
    { provide: HTTP_INTERCEPTORS, useClass: ErrorInterceptor, multi: true },
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
