/*
 * Translator.cpp
 *
 *  Created on: Aug 13, 2010
 *      Author: raluca
 */

#include <main/Translator.hh>
#include <util/cryptdb_log.hh>

#include <functional>
#include <ctime>

// TODO: Make length longer.
// TODO: Ensure some level of collision resistance.
std::string
getpRandomName(){
    // FIXME: Not using numbers because.
    //  'CREATE TABLE a (2e integer); <---- succeeds
    //  'CREATE TABLE b (2e5 integer); <--- fails
    static const char valids[] =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static int out_length = 10;
    char output[out_length + 1];
    std::function<bool()> wrap_srand =[](){srand(time(NULL)); return true;};
    std::function<void(bool)> do_nothing = [] (bool b) {return;};
    static bool danger_will_robinson = wrap_srand();
    do_nothing(danger_will_robinson);

    for (int i = 0; i < out_length; ++i) {
        output[i] = valids[rand() % strlen(valids)];
    }
    output[out_length] = 0;
    return std::string(output);
}

std::string
nextAutoInc(std::map<std::string, unsigned int > & autoInc,
            std::string fullname){
    std::string val;
    if (autoInc.find(fullname) == autoInc.end()) {
        val = "1";
        autoInc[fullname] = 1;
    } else {
        autoInc[fullname] += 1;
        val = strFromVal(autoInc[fullname]);
    }

    return val;
}

std::string
getTableSalt(std::string anonTableName) {
    return BASE_SALT_NAME + "_t_" + anonTableName;
}

std::string
getTableOfSalt(std::string salt_name) {
    return salt_name.substr(BASE_SALT_NAME.length() + 3, salt_name.length() - 3 - BASE_SALT_NAME.length());
}



std::string
getFieldsItSelect(std::list<std::string> & words,
                  std::list<std::string>::iterator & it) {
    it = words.begin();
    it++;
    std::string res = "SELECT ";

    if (equalsIgnoreCase(*it, "distinct")) {
        LOG(edb_v) << "has distinct!";
        it++;
        res += "DISTINCT ";
    }
    return res;
}

