#include "parser/showparser_helper.hh"

// maps for showing types

namespace SHOW{
    namespace KEY{
        std::map<int,std::string> trans{
            {Key::PRIMARY,"PRIMARY"},
            {Key::UNIQUE,"UNIQUE"},
            {Key::MULTIPLE,"MULTIPLE"},
            {Key::FULLTEXT,"FULLTEXT"},
            {Key::FOREIGN_KEY,"FOREIGN_KEY"},
            {Key::SPATIAL,"SPATIAL"}
        };
    }
    namespace SQLCOM{
        std::map<int,std::string> trans{
			{SQLCOM_SELECT, "SQLCOM_SELECT" },
			{SQLCOM_CREATE_TABLE, "SQLCOM_CREATE_TABLE" },
			{SQLCOM_CREATE_INDEX, "SQLCOM_CREATE_INDEX" },
			{SQLCOM_ALTER_TABLE, "SQLCOM_ALTER_TABLE" },
			{SQLCOM_UPDATE, "SQLCOM_UPDATE" },
			{SQLCOM_INSERT, "SQLCOM_INSERT" },
			{SQLCOM_INSERT_SELECT, "SQLCOM_INSERT_SELECT" },
			{SQLCOM_DELETE, "SQLCOM_DELETE" },
			{SQLCOM_TRUNCATE, "SQLCOM_TRUNCATE" },
			{SQLCOM_DROP_TABLE, "SQLCOM_DROP_TABLE" },
			{SQLCOM_DROP_INDEX, "SQLCOM_DROP_INDEX" },
			{SQLCOM_SHOW_DATABASES, "SQLCOM_SHOW_DATABASES" },
			{SQLCOM_SHOW_TABLES, "SQLCOM_SHOW_TABLES" },
			{SQLCOM_SHOW_FIELDS, "SQLCOM_SHOW_FIELDS" },
			{SQLCOM_SHOW_KEYS, "SQLCOM_SHOW_KEYS" },
			{SQLCOM_SHOW_VARIABLES, "SQLCOM_SHOW_VARIABLES" },
			{SQLCOM_SHOW_STATUS, "SQLCOM_SHOW_STATUS" },
			{SQLCOM_SHOW_ENGINE_LOGS, "SQLCOM_SHOW_ENGINE_LOGS" },
			{SQLCOM_SHOW_ENGINE_STATUS, "SQLCOM_SHOW_ENGINE_STATUS" },
			{SQLCOM_SHOW_ENGINE_MUTEX, "SQLCOM_SHOW_ENGINE_MUTEX" },
			{SQLCOM_SHOW_PROCESSLIST, "SQLCOM_SHOW_PROCESSLIST" },
			{SQLCOM_SHOW_MASTER_STAT, "SQLCOM_SHOW_MASTER_STAT" },
			{SQLCOM_SHOW_SLAVE_STAT, "SQLCOM_SHOW_SLAVE_STAT" },
			{SQLCOM_SHOW_GRANTS, "SQLCOM_SHOW_GRANTS" },
			{SQLCOM_SHOW_CREATE, "SQLCOM_SHOW_CREATE" },
			{SQLCOM_SHOW_CHARSETS, "SQLCOM_SHOW_CHARSETS" },
			{SQLCOM_SHOW_COLLATIONS, "SQLCOM_SHOW_COLLATIONS" },
			{SQLCOM_SHOW_CREATE_DB, "SQLCOM_SHOW_CREATE_DB" },
			{SQLCOM_SHOW_TABLE_STATUS, "SQLCOM_SHOW_TABLE_STATUS" },
			{SQLCOM_SHOW_TRIGGERS, "SQLCOM_SHOW_TRIGGERS" },
			{SQLCOM_LOAD, "SQLCOM_LOAD" },
			{SQLCOM_SET_OPTION, "SQLCOM_SET_OPTION" },
			{SQLCOM_LOCK_TABLES, "SQLCOM_LOCK_TABLES" },
			{SQLCOM_UNLOCK_TABLES, "SQLCOM_UNLOCK_TABLES" },
			{SQLCOM_GRANT, "SQLCOM_GRANT" },
			{SQLCOM_CHANGE_DB, "SQLCOM_CHANGE_DB" },
			{SQLCOM_CREATE_DB, "SQLCOM_CREATE_DB" },
			{SQLCOM_DROP_DB, "SQLCOM_DROP_DB" },
			{SQLCOM_ALTER_DB, "SQLCOM_ALTER_DB" },
			{SQLCOM_REPAIR, "SQLCOM_REPAIR" },
			{SQLCOM_REPLACE, "SQLCOM_REPLACE" },
			{SQLCOM_REPLACE_SELECT, "SQLCOM_REPLACE_SELECT" },
			{SQLCOM_CREATE_FUNCTION, "SQLCOM_CREATE_FUNCTION" },
			{SQLCOM_DROP_FUNCTION, "SQLCOM_DROP_FUNCTION" },
			{SQLCOM_REVOKE, "SQLCOM_REVOKE" },
			{SQLCOM_OPTIMIZE, "SQLCOM_OPTIMIZE" },
			{SQLCOM_CHECK, "SQLCOM_CHECK" },
			{SQLCOM_ASSIGN_TO_KEYCACHE, "SQLCOM_ASSIGN_TO_KEYCACHE" },
			{SQLCOM_PRELOAD_KEYS, "SQLCOM_PRELOAD_KEYS" },
			{SQLCOM_FLUSH, "SQLCOM_FLUSH" },
			{SQLCOM_KILL, "SQLCOM_KILL" },
			{SQLCOM_ANALYZE, "SQLCOM_ANALYZE" },
			{SQLCOM_ROLLBACK, "SQLCOM_ROLLBACK" },
			{SQLCOM_ROLLBACK_TO_SAVEPOINT, "SQLCOM_ROLLBACK_TO_SAVEPOINT" },
			{SQLCOM_COMMIT, "SQLCOM_COMMIT" },
			{SQLCOM_SAVEPOINT, "SQLCOM_SAVEPOINT" },
			{SQLCOM_RELEASE_SAVEPOINT, "SQLCOM_RELEASE_SAVEPOINT" },
			{SQLCOM_SLAVE_START, "SQLCOM_SLAVE_START" },
			{SQLCOM_SLAVE_STOP, "SQLCOM_SLAVE_STOP" },
			{SQLCOM_BEGIN, "SQLCOM_BEGIN" },
			{SQLCOM_CHANGE_MASTER, "SQLCOM_CHANGE_MASTER" },
			{SQLCOM_RENAME_TABLE, "SQLCOM_RENAME_TABLE" },
			{SQLCOM_RESET, "SQLCOM_RESET" },
			{SQLCOM_PURGE, "SQLCOM_PURGE" },
			{SQLCOM_PURGE_BEFORE, "SQLCOM_PURGE_BEFORE" },
			{SQLCOM_SHOW_BINLOGS, "SQLCOM_SHOW_BINLOGS" },
			{SQLCOM_SHOW_OPEN_TABLES, "SQLCOM_SHOW_OPEN_TABLES" },
			{SQLCOM_HA_OPEN, "SQLCOM_HA_OPEN" },
			{SQLCOM_HA_CLOSE, "SQLCOM_HA_CLOSE" },
			{SQLCOM_HA_READ, "SQLCOM_HA_READ" },
			{SQLCOM_SHOW_SLAVE_HOSTS, "SQLCOM_SHOW_SLAVE_HOSTS" },
			{SQLCOM_DELETE_MULTI, "SQLCOM_DELETE_MULTI" },
			{SQLCOM_UPDATE_MULTI, "SQLCOM_UPDATE_MULTI" },
			{SQLCOM_SHOW_BINLOG_EVENTS, "SQLCOM_SHOW_BINLOG_EVENTS" },
			{SQLCOM_DO, "SQLCOM_DO" },
			{SQLCOM_SHOW_WARNS, "SQLCOM_SHOW_WARNS" },
			{SQLCOM_EMPTY_QUERY, "SQLCOM_EMPTY_QUERY" },
			{SQLCOM_SHOW_ERRORS, "SQLCOM_SHOW_ERRORS" },
			{SQLCOM_SHOW_STORAGE_ENGINES, "SQLCOM_SHOW_STORAGE_ENGINES" },
			{SQLCOM_SHOW_PRIVILEGES, "SQLCOM_SHOW_PRIVILEGES" },
			{SQLCOM_HELP, "SQLCOM_HELP" },
			{SQLCOM_CREATE_USER, "SQLCOM_CREATE_USER" },
			{SQLCOM_DROP_USER, "SQLCOM_DROP_USER" },
			{SQLCOM_RENAME_USER, "SQLCOM_RENAME_USER" },
			{SQLCOM_REVOKE_ALL, "SQLCOM_REVOKE_ALL" },
			{SQLCOM_CHECKSUM, "SQLCOM_CHECKSUM" },
			{SQLCOM_CREATE_PROCEDURE, "SQLCOM_CREATE_PROCEDURE" },
			{SQLCOM_CREATE_SPFUNCTION, "SQLCOM_CREATE_SPFUNCTION" },
			{SQLCOM_CALL, "SQLCOM_CALL" },
			{SQLCOM_DROP_PROCEDURE, "SQLCOM_DROP_PROCEDURE" },
			{SQLCOM_ALTER_PROCEDURE, "SQLCOM_ALTER_PROCEDURE" },
			{SQLCOM_ALTER_FUNCTION, "SQLCOM_ALTER_FUNCTION" },
			{SQLCOM_SHOW_CREATE_PROC, "SQLCOM_SHOW_CREATE_PROC" },
			{SQLCOM_SHOW_CREATE_FUNC, "SQLCOM_SHOW_CREATE_FUNC" },
			{SQLCOM_SHOW_STATUS_PROC, "SQLCOM_SHOW_STATUS_PROC" },
			{SQLCOM_SHOW_STATUS_FUNC, "SQLCOM_SHOW_STATUS_FUNC" },
			{SQLCOM_PREPARE, "SQLCOM_PREPARE" },
			{SQLCOM_EXECUTE, "SQLCOM_EXECUTE" },
			{SQLCOM_DEALLOCATE_PREPARE, "SQLCOM_DEALLOCATE_PREPARE" },
			{SQLCOM_CREATE_VIEW, "SQLCOM_CREATE_VIEW" },
			{SQLCOM_DROP_VIEW, "SQLCOM_DROP_VIEW" },
			{SQLCOM_CREATE_TRIGGER, "SQLCOM_CREATE_TRIGGER" },
			{SQLCOM_DROP_TRIGGER, "SQLCOM_DROP_TRIGGER" },
			{SQLCOM_XA_START, "SQLCOM_XA_START" },
			{SQLCOM_XA_END, "SQLCOM_XA_END" },
			{SQLCOM_XA_PREPARE, "SQLCOM_XA_PREPARE" },
			{SQLCOM_XA_COMMIT, "SQLCOM_XA_COMMIT" },
			{SQLCOM_XA_ROLLBACK, "SQLCOM_XA_ROLLBACK" },
			{SQLCOM_XA_RECOVER, "SQLCOM_XA_RECOVER" },
			{SQLCOM_SHOW_PROC_CODE, "SQLCOM_SHOW_PROC_CODE" },
			{SQLCOM_SHOW_FUNC_CODE, "SQLCOM_SHOW_FUNC_CODE" },
			{SQLCOM_ALTER_TABLESPACE, "SQLCOM_ALTER_TABLESPACE" },
			{SQLCOM_INSTALL_PLUGIN, "SQLCOM_INSTALL_PLUGIN" },
			{SQLCOM_UNINSTALL_PLUGIN, "SQLCOM_UNINSTALL_PLUGIN" },
			{SQLCOM_SHOW_AUTHORS, "SQLCOM_SHOW_AUTHORS" },
			{SQLCOM_BINLOG_BASE64_EVENT, "SQLCOM_BINLOG_BASE64_EVENT" },
			{SQLCOM_SHOW_PLUGINS, "SQLCOM_SHOW_PLUGINS" },
			{SQLCOM_SHOW_CONTRIBUTORS, "SQLCOM_SHOW_CONTRIBUTORS" },
			{SQLCOM_CREATE_SERVER, "SQLCOM_CREATE_SERVER" },
			{SQLCOM_DROP_SERVER, "SQLCOM_DROP_SERVER" },
			{SQLCOM_ALTER_SERVER, "SQLCOM_ALTER_SERVER" },
			{SQLCOM_CREATE_EVENT, "SQLCOM_CREATE_EVENT" },
			{SQLCOM_ALTER_EVENT, "SQLCOM_ALTER_EVENT" },
			{SQLCOM_DROP_EVENT, "SQLCOM_DROP_EVENT" },
			{SQLCOM_SHOW_CREATE_EVENT, "SQLCOM_SHOW_CREATE_EVENT" },
			{SQLCOM_SHOW_EVENTS, "SQLCOM_SHOW_EVENTS" },
			{SQLCOM_SHOW_CREATE_TRIGGER, "SQLCOM_SHOW_CREATE_TRIGGER" },
			{SQLCOM_ALTER_DB_UPGRADE, "SQLCOM_ALTER_DB_UPGRADE" },
			{SQLCOM_SHOW_PROFILE, "SQLCOM_SHOW_PROFILE" },
			{SQLCOM_SHOW_PROFILES, "SQLCOM_SHOW_PROFILES" },
			{SQLCOM_SIGNAL, "SQLCOM_SIGNAL" },
			{SQLCOM_RESIGNAL, "SQLCOM_RESIGNAL" },
			{SQLCOM_SHOW_RELAYLOG_EVENTS, "SQLCOM_SHOW_RELAYLOG_EVENTS" },
			{SQLCOM_END, "SQLCOM_END" }
        };
    }
    namespace ALTER{
        std::map<long long,std::string> trans{
			{ALTER_ADD_COLUMN,"ALTER_ADD_COLUMN"},
			{ALTER_DROP_COLUMN,"ALTER_DROP_COLUMN"},
			{ALTER_CHANGE_COLUMN,"ALTER_CHANGE_COLUMN"},
			{ALTER_ADD_INDEX,"ALTER_ADD_INDEX"},
			{ALTER_DROP_INDEX,"ALTER_DROP_INDEX"},
			{ALTER_RENAME,"ALTER_RENAME"},
			{ALTER_ORDER,"ALTER_ORDER"},
			{ALTER_OPTIONS,"ALTER_OPTIONS"},
			{ALTER_CHANGE_COLUMN_DEFAULT,"ALTER_CHANGE_COLUMN_DEFAULT"},
			{ALTER_KEYS_ONOFF,"ALTER_KEYS_ONOFF"},
			{ALTER_CONVERT,"ALTER_CONVERT"},
			{ALTER_RECREATE,"ALTER_RECREATE"},
			{ALTER_ADD_PARTITION,"ALTER_ADD_PARTITION"},
			{ALTER_DROP_PARTITION,"ALTER_DROP_PARTITION"},
			{ALTER_COALESCE_PARTITION,"ALTER_COALESCE_PARTITION"},
			{ALTER_REORGANIZE_PARTITION,"ALTER_REORGANIZE_PARTITION"},
			{ALTER_PARTITION,"ALTER_PARTITION"},
			{ALTER_ADMIN_PARTITION,"ALTER_ADMIN_PARTITION"},
			{ALTER_TABLE_REORG,"ALTER_TABLE_REORG"},
			{ALTER_REBUILD_PARTITION,"ALTER_REBUILD_PARTITION"},
			{ALTER_ALL_PARTITION,"ALTER_ALL_PARTITION"},
			{ALTER_REMOVE_PARTITIONING,"ALTER_REMOVE_PARTITIONING"},
			{ALTER_FOREIGN_KEY,"ALTER_FOREIGN_KEY"},
			{ALTER_TRUNCATE_PARTITION,"ALTER_TRUNCATE_PARTITION"}            
        };
    }

    namespace ITEM{
    	std::map<int,std::string> trans{
			{Item::FIELD_ITEM ,"FIELD_ITEM"},
			{Item::FUNC_ITEM ,"FUNC_ITEM"},
			{Item::SUM_FUNC_ITEM ,"SUM_FUNC_ITEM"},
			{Item::STRING_ITEM ,"STRING_ITEM"},
			{Item::INT_ITEM ,"INT_ITEM"},
			{Item::REAL_ITEM ,"REAL_ITEM"},
			{Item::NULL_ITEM ,"NULL_ITEM"},
			{Item::VARBIN_ITEM ,"VARBIN_ITEM"},
			{Item::COPY_STR_ITEM ,"COPY_STR_ITEM"},
			{Item::FIELD_AVG_ITEM ,"FIELD_AVG_ITEM"},
			{Item::DEFAULT_VALUE_ITEM ,"DEFAULT_VALUE_ITEM"},
			{Item::PROC_ITEM ,"PROC_ITEM"},
			{Item::COND_ITEM ,"COND_ITEM"},
			{Item::REF_ITEM ,"REF_ITEM"},
			{Item::FIELD_STD_ITEM ,"FIELD_STD_ITEM"},
			{Item::FIELD_VARIANCE_ITEM ,"FIELD_VARIANCE_ITEM"},
			{Item::INSERT_VALUE_ITEM ,"INSERT_VALUE_ITEM"},
			{Item::SUBSELECT_ITEM ,"SUBSELECT_ITEM"},
			{Item::ROW_ITEM ,"ROW_ITEM"},
			{Item::CACHE_ITEM ,"CACHE_ITEM"},
			{Item::TYPE_HOLDER ,"TYPE_HOLDER"},
			{Item::PARAM_ITEM ,"PARAM_ITEM"},
			{Item::TRIGGER_FIELD_ITEM ,"TRIGGER_FIELD_ITEM"},
			{Item::DECIMAL_ITEM ,"DECIMAL_ITEM"},
			{Item::XPATH_NODESET ,"XPATH_NODESET"},
			{Item::XPATH_NODESET_CMP ,"XPATH_NODESET_CMP"},
			{Item::VIEW_FIXER_ITEM ,"VIEW_FIXER_ITEM"}
    	};
    }
}

